/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.rss;

import data.base.NoBaseException;

public class CollecteurSujets extends Thread {

    private String etat = "pas de lecture en cours";
    private String erreur = "";
    private boolean enCours = false;
    private int derniereCollecte = 0;
    private long dernierDepart = 0;
    private boolean running = false;
    private boolean stop = false;
    private NewsSaver collecteur;

    public CollecteurSujets(NewsSaver collecteur) {
        this.collecteur = collecteur;
    }

    @Override
    public void run() {
        while(running) {
            dernierDepart = System.currentTimeMillis();
            try {
                etat = "lecture en cours ";
                enCours = true;
                //System.out.println("Lancement de la lecture de sujets");
                derniereCollecte = collecteur.readNews();
                //System.out.println("Lecture de sujets terminée : "+derniereCollecte+" sujets");
                if (derniereCollecte == -1) {
                    erreur = collecteur.getReadErrorMessage();
                }
                etat = "<i>lecture terminée </i>";
                enCours = false;
            } catch(NoBaseException nbe){
                erreur = "Base indisponible.";
                enCours = false;
            }
            try {
                Thread.sleep(60000);
            } catch (InterruptedException ie) {
                // C'est reparti !
            }
        }
        stop = true;
    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public void fin() {
        running = false;
    }

    public boolean isRunning() {
        return running;
    }

    public boolean isStopped() {
        return stop;
    }

    public long getTemps() {
        long elapsed = System.currentTimeMillis() - dernierDepart;
        return elapsed;
    }

    public NewsSaver getCollecteur() {
        return collecteur;
    }

    public String toString() {
        if (stop) {
            return "<html><i>Arrêté pour cause de lecture trop longue.</i>";
        }
        if (enCours) {
            long elapsed = System.currentTimeMillis() - dernierDepart;
            String hr = "" + (elapsed / 3600000);
            if (hr.length() < 2) {
                hr = "0" + hr;
            }
            String mn = "" + (elapsed % 3600000 / 60000);
            if (mn.length() < 2) {
                mn = "0" + mn;
            }
            String s = "" + (elapsed % 60000 / 1000);
            if (s.length() < 2) {
                s = "0" + s;
            }
            String ss = "";
            if (derniereCollecte == -1) {
                ss = "<b>erreur de collecte</b> (<i>" + erreur + "</i>).";
            } else if (derniereCollecte == 0) {
            } else {
                ss = "<b>" + derniereCollecte + " entrée" + (derniereCollecte > 1 ? "s" : "") + " à traiter.</b></i>";
            }
            if (elapsed < 300000) {
                return "<html>" + ss + " - " + etat + " - " + hr + ":" + mn + ":" + s + ".";
            } else {
                return "<html><font color=\"#800000\">" + ss + " - " + etat + " - " + hr + ":" + mn + ":" + s + ".";
            }
        } else {
            if (derniereCollecte == -1) {
                return "<html>" + "<b>erreur de collecte</b> (<i>" + erreur + "</i>).";
            } else if (derniereCollecte == 0) {
                return "<html>" + etat + ".";
            } else {
                return "<html>" + "<b>" + derniereCollecte + " entrée" + (derniereCollecte > 1 ? "s" : "") + " à traiter.</b></i>";
            }
        }
    }
}
